# Quick Start Guide

## Basic Usage

To edit a case opinion for a casebook, provide:

1. **The case text**: Full opinion (paste or provide as file)
2. **Pedagogical goal**: "I'm including this case to teach students [specific concept]"
3. **Target length**: "Reduce to 2,000 words" or "Reduce to 30% of original"

## Example Request

```
I need to edit the attached Supreme Court opinion for my Constitutional Law 
casebook. The case is being included in the chapter on the dormant Commerce 
Clause. The primary pedagogical goal is to teach students how the Court applies 
the Pike balancing test when a state health or safety regulation burdens 
interstate commerce.

Please reduce the opinion from its current 12,000 words to approximately 2,500 
words. I want to preserve:
- The essential facts showing the burden on interstate commerce
- The Court's statement and application of the Pike test
- The key passage where the Court weighs the benefits against the burdens

You can aggressively cut:
- The standing discussion (first 3 pages)
- The preemption analysis (which we'll cover in a different case)
- Long string citations
```

## What to Expect

The edited case will:
- Use `...` for deletions
- Use `[brackets]` for summarized or added text
- Preserve the court's exact language for key legal passages
- Maintain facts that are legally critical, even if they seem minor
- Include editing notes explaining what was cut and why

## Using the Analysis Script

Before editing, you can analyze the original opinion:

```bash
python3 scripts/analyze_opinion.py opinion.txt 2500
```

This will show:
- Current word count
- How much needs to be cut
- Suggested word allocation by section

## Tips for Best Results

1. **Be specific about the pedagogical goal**: Don't just say "to teach Commerce Clause." Say "to teach the Pike balancing test" or "to show how courts distinguish substantial burdens from incidental effects."

2. **Indicate what's dispensable**: If you know certain sections can be cut entirely (other legal issues, concurrences you don't need), mention them.

3. **Flag important dicta**: If there's dicta you want preserved because it became important later, let me know.

4. **Provide chapter context**: If this case builds on or sets up another case in your book, mention it. Context affects editing choices.

## Common Follow-Up Requests

After the initial edit, you might ask to:
- "Restore the paragraph about [X] because students will need that for the next case"
- "Cut more—can we get to 2,000 words?"
- "The facts section is too sparse—add back details about [Y]"
- "Include more of the dissent's critique of the majority's [Z] analysis"

## For More Detail

See `references/editing-examples.md` for annotated examples showing how these principles work in practice.
