# Editing Examples and Best Practices

This file provides concrete examples of the principles outlined in SKILL.md.

## Example 1: Fact Selection

### Pedagogical Goal
Teach students how courts apply the Pike balancing test to state safety regulations under the dormant Commerce Clause.

### Original Facts (excerpt)
```
The plaintiff, Consolidated Freightways Corporation, is a large trucking company
that operates in 47 states. In 1973, the company purchased 150 new double-trailer
trucks at a cost of $3.2 million. Each truck was equipped with standard 60-inch
mudflaps, which had been approved by the Department of Transportation and were
in use in most states. The mudflaps were manufactured by FleetGuard Industries
of Ohio, a leading supplier with 40 years of experience. The company's CEO,
Robert Morrison, testified that the mudflaps had an excellent safety record.

In 1974, Wisconsin enacted a statute requiring all trucks operating in the state
to use 65-inch curved mudflaps. The statute provided no exemption for out-of-state
trucks passing through Wisconsin. Compliance would require Consolidated to either
re-route around Wisconsin (adding approximately 400 miles to cross-country routes)
or replace the mudflaps on all trucks entering Wisconsin (at a cost of $45,000).
```

### Poor Edit
```
Plaintiff is a trucking company that uses 60-inch mudflaps on its trucks. Wisconsin
required 65-inch curved mudflaps. [Additional background omitted.]
```

**What's wrong**: This edit removes the specific cost burden ($45,000, 400-mile detour), which is critical for the Pike balancing test—the court needs to weigh the burden on commerce against the safety benefit.

### Good Edit
```
Consolidated Freightways Corporation operates trucks equipped with standard 60-inch
mudflaps in 47 states. Wisconsin enacted a statute requiring 65-inch curved mudflaps
with no exemption for through traffic. Compliance would require Consolidated to either
re-route around Wisconsin (adding 400 miles to cross-country routes) or replace mudflaps
on all Wisconsin-bound trucks at a cost of $45,000. [Background on the CEO and
manufacturer history omitted.]
```

**Why it works**: Preserves the quantified burden (miles, dollars) needed for balancing test, removes the dramatic background narrative.

## Example 2: Preserving Awkward Reasoning

### Pedagogical Goal
Illustrate how courts struggle with the "substantial factor" test in tort causation.

### Original Text
```
We acknowledge that the "substantial factor" test, while widely adopted, presents
certain analytical difficulties. The question of what constitutes a "substantial"
contribution to the plaintiff's injury is, in some sense, a question that cannot
be answered with precision through abstract formulation. We might say that a factor
is substantial when it is not de minimis, but this merely restates the question.
Alternatively, we might say that a factor is substantial when, but for the factor,
the injury would not have occurred—but this collapses the substantial factor test
into the but-for test, which we have said are distinct. We are therefore left with
the conclusion that substantiality is a question for the jury, guided by instructions
that emphasize the commonsense meaning of "substantial."
```

### Poor Edit (Over-Cleaned)
```
The "substantial factor" test requires a factor to be more than de minimis. This
is determined by the jury using common sense.
```

**What's wrong**: The professor likely included this case precisely because the court's reasoning is circular and awkward. Students need to see that courts sometimes struggle with these standards. "Cleaning" it up removes the teaching value.

### Good Edit
```
[The court first discusses the history of the substantial factor test...] We acknowledge
that the "substantial factor" test, while widely adopted, presents certain analytical
difficulties. The question of what constitutes a "substantial" contribution to the
plaintiff's injury is, in some sense, a question that cannot be answered with precision
through abstract formulation. We might say that a factor is substantial when it is not
de minimis, but this merely restates the question. Alternatively, we might say that a
factor is substantial when, but for the factor, the injury would not have occurred—but
this collapses the substantial factor test into the but-for test, which we have said
are distinct. We are therefore left with the conclusion that substantiality is a question
for the jury, guided by instructions that emphasize the commonsense meaning of "substantial."
```

**Why it works**: Preserves the court's struggle with the standard, allowing the professor to discuss why legal tests sometimes resist precise formulation.

## Example 3: Handling Multi-Issue Cases

### Scenario
A case addresses three issues: (1) standing, (2) statutory interpretation, (3) constitutional question. The pedagogical goal is to teach statutory interpretation using canons of construction.

### Poor Approach
Summarize all three issues briefly to give students the "full picture."

**What's wrong**: This dilutes the focus. Students will be confused about which issue matters. The standing discussion uses valuable word count but teaches nothing relevant to the chapter.

### Good Approach
```
[The Court first addressed standing, concluding that plaintiffs had suffered sufficient
injury-in-fact because they were denied permits they had applied for. That discussion
is omitted here.]

The central question is whether the term "navigable waters" in the Clean Water Act
encompasses isolated wetlands that are not adjacent to open bodies of water...

[... full treatment of statutory interpretation issue ...]

[The Court declined to reach the constitutional question, finding the statute
unambiguous. That discussion is omitted.]
```

**Why it works**: Brackets provide orientation without using precious word count. Students know other issues existed but focus remains on the pedagogical goal.

## Example 4: Dissent Selection

### Scenario
A 4-3 decision with a majority opinion, a concurrence, and two dissents (one focused on legal reasoning, one focused on policy consequences).

### Pedagogical Goal
Teach the majority's application of textualism to statutory interpretation.

### Poor Approach
Include both dissents to show "both sides."

### Good Approach
Include only the dissent that challenges the majority's textualist methodology:

```
Justice Marshall, dissenting:

The majority's exclusive focus on textual canons ignores the statute's purpose. [The
dissent then recounts extensive legislative history suggesting Congress intended a
broader interpretation...] Even if the text is ambiguous, as the majority concedes,
we should prefer the interpretation that advances Congress's remedial goals rather
than the cramped reading the majority adopts.

[Justice Blackmun's separate dissent, addressing the policy consequences of the majority's
holding, is omitted.]
```

**Why it works**: Includes the dissent that engages with the textualist/purposivist debate (the teaching point), omits the policy-focused dissent that doesn't advance the pedagogical goal.

## Common Pitfalls and Solutions

### Pitfall: "Context Dumping"
**Problem**: Keeping lengthy background about the industry, technology, or regulatory framework because it provides "helpful context."

**Solution**: Keep only the minimum context needed to understand the legal issue. Students can learn industry details elsewhere; class time is for legal reasoning.

### Pitfall: "Precedent Overload"
**Problem**: Keeping all the case citations and distinguishing because they show "how courts reason through precedent."

**Solution**: Unless the pedagogical goal is specifically about precedent analysis, reduce most citations to: `... [citing cases]` or `... See, e.g., [key case] ...`

### Pitfall: "Democratic Editing"
**Problem**: Cutting equally from all sections to reach the word count target.

**Solution**: Make surgical cuts. Some sections should be removed entirely; others should be nearly untouched. Weight your cuts based on relevance to the pedagogical goal.

### Pitfall: "Smoothness Priority"
**Problem**: Editing to make the opinion flow better, removing repetition or awkward transitions.

**Solution**: Preserve the court's original structure and language, warts and all. Legal writing pedagogy includes learning to read difficult judicial prose.

## Word Count Allocation Guidelines

These are general guidelines, not rigid rules. Adjust based on the specific case.

For a typical edited case of 2,000-3,000 words:

- **Facts**: 300-450 words (15%)
  - Essential background only
  - Legally critical details preserved
  
- **Procedural History**: 100-150 words (5%)
  - Usually a bracketed summary
  - More detail only if procedure is the teaching point

- **Legal Standard/Test**: 200-300 words (10%)
  - Full statement of the test or rule
  - Usually quoted directly from opinion
  
- **Core Reasoning**: 1,200-2,100 words (60%)
  - This is where you spend your word budget
  - The application of law to facts
  - The court's analytical moves
  
- **Dissent** (if included): 200-300 words (10%)
  - Only the portion directly challenging the majority's reasoning
  - Skip dissents entirely if they don't serve the pedagogical goal

## Bracket Usage Guidelines

### When to Use Brackets

1. **Summarizing procedural history**: `[The district court granted summary judgment, and the court of appeals affirmed.]`

2. **Noting omissions**: `[The Court's discussion of ripeness is omitted.]`

3. **Adding clarifying information**: `[The statute at issue, 42 U.S.C. § 1983, provides that ...]`

4. **Summarizing removed reasoning**: `[The Court rejected three alternative arguments, finding them unpersuasive for reasons discussed at length in the original opinion.]`

### When NOT to Use Brackets

1. **Never invent facts**: If the opinion says "The plaintiff alleged discrimination," do not write `[The plaintiff alleged race and gender discrimination.]` unless the opinion specifies those bases.

2. **Never editorialize**: Do not add `[This reasoning seems questionable.]` or `[This is the key passage.]` Let the professor provide that framing in class.

3. **Never "improve" the court's language**: If the court writes awkwardly, preserve it. Do not write `[The Court's reasoning here is that...]` to "explain" what the court meant.

## Length Triage Decision Tree

```
Cannot meet target length?
│
├─ Is pedagogical goal too broad?
│  └─ YES → Recommend narrowing the goal
│  └─ NO → Continue to next question
│
├─ Are there multi-issue discussions to remove?
│  └─ YES → Remove entire unrelated sections
│  └─ NO → Continue to next question
│
├─ Have you cut all string citations and boilerplate?
│  └─ NO → Do this first
│  └─ YES → Continue to next question
│
├─ Have you condensed procedural history to 1-2 sentences?
│  └─ NO → Do this now
│  └─ YES → Continue to next question
│
├─ Would further cuts compromise the pedagogical goal?
│  └─ YES → Recommend increasing target length by 10-20%
│  └─ NO → Make deeper cuts to facts and tangential reasoning
```

## Quality Checklist

Before delivering the edited case, verify:

- [ ] Every bracketed statement is verifiable against original text
- [ ] All facts that the court explicitly relies upon in its reasoning are present
- [ ] The court's logical structure remains intact (if premise A, then B, therefore C)
- [ ] Key legal language is quoted exactly, not paraphrased
- [ ] The edited case still clearly demonstrates the pedagogical goal
- [ ] Target length achieved (within 5%)
- [ ] No orphaned references (e.g., "As discussed above" when the above section was cut)
- [ ] Ellipses and brackets used correctly per legal editing conventions
