---
name: casebook-editor
description: Edit judicial opinions for law school casebooks by strategically condensing opinions while preserving pedagogical value. Use when professors need to prepare case opinions for teaching, reduce lengthy opinions to appropriate length while maintaining legal reasoning, or adapt judicial writing for classroom use. Handles fact selection, procedural history summarization, and preservation of teaching points.
---

# Casebook Editor

Edit judicial opinions into pedagogically effective casebook materials.

## Overview

This skill transforms lengthy judicial opinions into focused teaching materials for law school casebooks. The challenge is not simple text reduction—it requires preserving the specific legal reasoning that makes a case pedagogically valuable while removing extraneous material.

## Input Parameters

Require these inputs from the user before beginning:

1. **Case text**: The complete judicial opinion
2. **Pedagogical goal**: Why this case is being included
   - Example: "To teach students how the Court applies the Pike balancing test to state health regulations"
   - This is the most critical input—it determines every editing decision
3. **Target length**: Either a specific word count (e.g., "2,000 words") or a reduction factor (e.g., "reduce to 25% of original")
4. **Chapter context** (optional): What students have already learned or will learn next

## Workflow

### Phase 1: Analysis

Before making any edits, perform a complete analysis:

1. **Identify structural components**:
   - Facts section
   - Procedural history
   - Legal standard/test announced or applied
   - Core reasoning (directly related to pedagogical goal)
   - Alternative reasoning or dicta
   - Concurring/dissenting opinions

2. **Map reasoning to pedagogical goal**:
   - Highlight every paragraph that directly advances the pedagogical goal
   - Note paragraphs that provide essential context even if not central
   - Identify tangential issues that can be removed entirely

3. **Calculate current vs. target metrics**:
   - Current word count
   - Target word count
   - Required reduction percentage
   - Estimate space allocation: facts (15%), procedural history (5%), reasoning (75%), dissent (5%)

### Phase 2: Strategic Editing

Apply these editing operations in sequence:

#### 1. Remove Entire Sections

Aggressively excise these elements entirely:

- **Unrelated legal issues**: If the opinion addresses multiple issues (e.g., standing, preemption, and the merits), remove all discussion of issues unrelated to the pedagogical goal
- **String citations**: Replace lengthy case lists with ellipses
- **Standard of review boilerplate**: Remove unless the standard itself is the teaching point
- **Procedural minutiae**: Remove detailed procedural back-and-forth unless procedurally significant

Mark deletions with `...` for single-sentence cuts, or `[... lengthy discussion of X omitted ...]` for multi-paragraph deletions.

#### 2. Condense Procedural History

Create a 1-2 sentence summary in brackets:

- Template: `[The case arose when X. The lower court held Y, and appellant/appellee argues Z.]`
- Include only facts necessary to understand why the case is before this court
- **Critical**: Never invent procedural facts—only summarize what is actually in the opinion

#### 3. Edit Facts with Precision

**Warning**: This is where AI typically fails. Apply these rules rigorously:

- **Preserve linchpin facts**: Keep any fact that the court's reasoning explicitly relies upon, even if it seems minor
  - Example: In a dormant Commerce Clause case about truck regulations, the specific mudflap dimension might be legally critical
- **Cut narrative details**: Remove dramatic storytelling that doesn't affect the legal analysis
- **Test each fact**: Ask "If I remove this, will the court's reasoning become incomprehensible?" If yes, keep it

**Anti-pattern**: Do not "clean up" the facts into a tidy story. The original opinion's organization often reflects what the court found important.

#### 4. Preserve Core Reasoning

For the sections directly advancing the pedagogical goal:

- **Retain the court's exact language** for key doctrinal statements, tests, or holdings
- **Keep logical transitions**: Preserve phrases like "This is so because..." or "The critical distinction is..." that show the court's reasoning structure
- **Maintain examples**: If the court uses hypotheticals or examples to illustrate the rule, these are often pedagogically valuable

**Anti-pattern**: Do not paraphrase or "improve" the court's reasoning. Awkward judicial writing is often intentionally preserved to teach students to parse difficult legal text.

#### 5. Handle Dissents/Concurrences

Extract only the portion that:
- Directly challenges the majority's reasoning on the pedagogical goal
- Represents an alternative analytical framework students should understand

**Anti-pattern**: Do not include dissents merely for completeness. Include them only when they advance teaching objectives.

### Phase 3: Quality Control

Before outputting, verify:

1. **Length target met**: Within 5% of specified target
2. **Pedagogical goal preserved**: The edited case still clearly demonstrates the concept
3. **No hallucinations**: Every bracketed summary is verifiable against the original
4. **Fact completeness**: All legally critical facts present
5. **Reasoning coherence**: The court's logical flow remains intact

## Critical Anti-Patterns

Avoid these common AI failures:

### 1. Pedagogical Blind Spot

**Problem**: Treating all reasoning as equally important.

**Solution**: Weight editing decisions heavily toward the pedagogical goal. If a paragraph doesn't directly serve that goal, it should be cut or drastically reduced, even if legally interesting.

### 2. Over-Cleaning

**Problem**: "Fixing" awkward judicial writing or removing passages that seem redundant.

**Solution**: Preserve the original text's friction. Students must learn to parse unclear judicial writing. Only clean up formatting or obvious typographical errors.

### 3. Fact Misjudgment

**Problem**: Cutting seemingly minor facts that are actually legally critical, or keeping dramatic details that are legally irrelevant.

**Solution**: Map each fact to the court's reasoning. If the court explicitly references a fact in its analysis, keep it. If a fact appears only in the background narrative, consider cutting it.

### 4. Hallucination Risk

**Problem**: Creating plausible-sounding bracketed summaries that don't accurately reflect the original text.

**Solution**: After creating any bracketed summary, verify it against the original. When uncertain, quote the original text or use more ellipses rather than summarizing.

## Output Format

**Default format**: Output as a markdown (.md) file unless otherwise specified.

Structure the output as:

```
[Case citation with year, e.g., 606 U.S. 442 (2025)]

[Edited opinion using standard legal editing conventions]

---
EDITING NOTES:
- Original word count: X
- Final word count: Y
- Reduction: Z%
- Pedagogical goal: [restate goal]
- Sections removed: [list major sections cut entirely]
- Cautions: [flag any edits that required difficult judgment calls]
```

Use these formatting conventions:
- `...` for deletions of sentences or short passages
- `[... detailed discussion of X omitted ...]` for multi-paragraph deletions
- `[Square brackets]` for all added or summarized text
- Standard legal citation format (Bluebook if no other instruction)
- Include the year in case citations in the heading (e.g., "606 U.S. 442 (2025)" not "606 U.S. 442")

**Critical text preservation rules**:
- **Never use typographical emphasis** (bold, italics, underlining, etc.) even if instructed to emphasize certain text
- **Never change the original text formatting** - preserve the exact typographical appearance from the source
- If emphasis is requested, simply include the relevant text without any typographical changes
- The goal is to preserve the original face of the text exactly as it appears in the judicial opinion

## Advanced Considerations

### Handling Complex Multi-Issue Cases

When a case addresses multiple legal issues but only one is pedagogically relevant:

1. Cut entire sections on other issues without summarizing them
2. Add a bracketed note: `[The Court also addressed [issue], holding [brief statement]. That discussion is omitted.]`
3. If the pedagogically relevant issue depends on resolution of another issue, provide minimal context

### Preserving Influential Dicta

If the professor indicates that dicta in the case became important in later doctrine:

- Preserve that dicta even if not central to the case's holding
- Flag it in editing notes as "dicta preserved for doctrinal continuity"

### Length Triage

If unable to meet the target length while preserving the pedagogical goal:

1. **First**: Check if the pedagogical goal is too broad. Consider narrowing it.
2. **Second**: Recommend a slightly longer length that preserves teaching value
3. **Third**: If user insists on length, flag that the edit may compromise teaching effectiveness

## For Additional Guidance

See `references/editing-examples.md` for annotated examples of well-edited cases demonstrating these principles in practice.
